/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.ptmp.PacketTracerConnection;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class LowLevelReadThread
extends Thread {
    protected BlockingQueue<ByteBuffer> messageList;
    protected PacketTracerConnection connection;
    protected boolean shouldStop = false;
    protected boolean useBinaryEncoding = false;
    protected ByteBuffer inputBuffer;
    protected byte[] rawBuffer;
    protected int writePosition;

    public LowLevelReadThread(PacketTracerConnection packetTracerConnection) {
        this.connection = packetTracerConnection;
        this.useBinaryEncoding = packetTracerConnection.connectionNegotiationProperties().isBinaryEncoding();
        this.messageList = new LinkedBlockingQueue<ByteBuffer>();
    }

    public ByteBuffer getNextMessage() throws Exception {
        return this.messageList.take();
    }

    public void shouldStop() {
        this.shouldStop = true;
        this.interrupt();
    }

    public void run() {
        this.inputBuffer = ByteBuffer.allocate(100000);
        this.initializeRawBuffer();
        while (!this.shouldStop) {
            try {
                while (!this.hasCompleteLengthField()) {
                    this.readIntoRawBuffer();
                }
                int n = this.extractLengthField();
                this.grow(n + 20);
                while (this.getReadSize() < n) {
                    this.readIntoRawBuffer();
                }
                byte[] byArray = this.extract(n);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                this.messageList.put(byteBuffer);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                this.connection.noteLowLevelReadError(throwable);
            }
        }
    }

    protected int readIntoRawBuffer() throws Exception {
        int n = this.connection.read(this.inputBuffer);
        if (n > 0) {
            if (n > this.getWriteSize()) {
                this.growBy(n - this.getWriteSize());
            }
            this.inputBuffer.flip();
            this.inputBuffer.get(this.rawBuffer, this.writePosition, n);
            this.writePosition += n;
            this.inputBuffer.clear();
        } else if (n == -24 || n < 0) {
            throw new Exception("Bad read of message from PacketTracer");
        }
        return n;
    }

    protected void initializeRawBuffer() {
        this.rawBuffer = new byte[20000];
        this.writePosition = 0;
    }

    protected boolean hasCompleteLengthField() {
        if (this.useBinaryEncoding) {
            return this.getReadSize() >= 4;
        }
        return this.getFirstTextDelimiterIndex() >= 0;
    }

    protected int getFirstTextDelimiterIndex() {
        for (int i = 0; i < this.writePosition; ++i) {
            if (this.rawBuffer[i] != 0) continue;
            return i;
        }
        return -1;
    }

    protected int extractLengthField() {
        if (this.useBinaryEncoding) {
            byte[] byArray = this.extract(4);
            byte by = byArray[0];
            byte by2 = byArray[1];
            byte by3 = byArray[2];
            byte by4 = byArray[3];
            return (by << 24) + (by2 << 16) + (by3 << 8) + by4;
        }
        byte[] byArray = this.extract(this.getFirstTextDelimiterIndex());
        this.extract(1);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return Integer.parseInt(stringBuilder.toString());
    }

    protected byte[] extract(int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = this.rawBuffer[n2];
        }
        for (n2 = n; n2 < this.writePosition; ++n2) {
            this.rawBuffer[n2 - n] = this.rawBuffer[n2];
        }
        this.writePosition -= n;
        return byArray;
    }

    protected int getReadSize() {
        return this.writePosition;
    }

    protected int getWriteSize() {
        return this.rawBuffer.length - this.writePosition;
    }

    protected void growBy(int n) {
        this.grow(this.rawBuffer.length + n);
    }

    protected void grow(int n) {
        if (this.rawBuffer.length >= n) {
            return;
        }
        int n2 = (int)Math.round(1.5 * (double)this.rawBuffer.length);
        int n3 = Math.max(n, n2);
        byte[] byArray = new byte[n3];
        for (int i = 0; i < this.writePosition; ++i) {
            byArray[i] = this.rawBuffer[i];
        }
        this.rawBuffer = byArray;
    }

    protected void show(String string, byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = (char)(byArray[n2] == 0 ? 95 : (char)byArray[n2]);
        }
    }
}

